/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	LinearDimension.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CDrawing.h"
#include "CApplication.h"


HRESULT LinearDimension(IDesign *pDesign, IDrawingDocument *pDrawingDoc, IGraphic *pGraph1, IGraphic *pGraph2, ILinearDimLine **lineardim)
{
	//	Creates a Linear Dimension
	START_METHOD("LinearDimension")

	HRESULT status = CONV_SUCCESS ;

	CHECK_VAR_STATUS(pDrawingDoc)

	IDrawingDocOthers *doc1 = NULL;
	IDrawingDocument *activeDoc = CAST(IDrawingDocument, pDrawingDoc);

	IGraphicDocument *activeGraphicDoc = CAST(IGraphicDocument, activeDoc);

	doc1 = CAST(IDrawingDocOthers, pDrawingDoc);

	IDrawing *localDraw = NULL;
	status = activeDoc->GetDrawing(&localDraw);
	CHECK_RETURN_STATUS(status)

	IDesignDetail *pDetail = NULL;
	status = localDraw->GetDetail(pDesign, FALSE, &pDetail);
	CHECK_RETURN_STATUS(status)

	IGeometry *localGeom1 = NULL;
	status = activeDoc->GetPaperGeometry(pGraph1, &localGeom1);
	CHECK_RETURN_STATUS(status)

	IGeometry  *localGeom2 = NULL;
	status = activeDoc->GetPaperGeometry(pGraph2, &localGeom2);
	CHECK_RETURN_STATUS(status)

	IDesignInstance *pView1 = NULL;
	status = localGeom1->GetInstance(&pView1);
	CHECK_RETURN_STATUS(status)
	
	IDesignInstance *pView2 = NULL;
	status = localGeom2->GetInstance(&pView2);
	CHECK_RETURN_STATUS(status)

//	IDrawingDocStatic *localStaticDoc = CAST(IDrawingDocStatic, pDrawingDoc);

	IDispatch *pDefinition = NULL;
//	status = localStaticDoc->CreateLinearDefn(localGeom1, localGeom2, &pDefinition);
	CHECK_RETURN_STATUS(status)
	
	IDimension *pDimension = NULL;
	status = (GetCLASS(Dimension))->CreateDimension(pDetail, 1, CAST(IGeometry, pDefinition), &pDimension);
	CHECK_RETURN_STATUS(status)
	
	IVector *pPosition= NULL;
	status = (GetCLASS(Vector))->CreateVector(0.001, 0.001, 0, &pPosition);
	CHECK_RETURN_STATUS(status)

	ILinearDimLine *pLinearDim = NULL;
	status = (GetCLASS(LinearDimLine))->CreateLinearDimLine(pPosition, pDimension, CAST(IHiddenLine, pView1), CAST(IHiddenLine, pView2), &pLinearDim);
	CHECK_RETURN_STATUS(status)
	
	IDimTol *pTolerance = NULL;
	status = (GetCLASS(DimTol))->CreateDimTol(pDetail, pDimension,&pTolerance);
	CHECK_RETURN_STATUS(status)

	IDimensionCallout *pCallout = NULL;
	status = (GetCLASS(DimensionCallout))->CreateDimensionCallout(pTolerance,&pCallout);
	CHECK_RETURN_STATUS(status)

	IDimLineText *pText = NULL;
	status = (GetCLASS(DimLineText))->CreateDimLineText(CAST(IDimLine, pLinearDim), CAST(ICallout, pCallout), pPosition, 0.0035, &pText);
	CHECK_RETURN_STATUS(status)
	
	ICalloutGroup *localCalloutGroup = CAST(ICalloutGroup, pText);

	status = localCalloutGroup->SetControlPoint(1, pPosition);
	CHECK_RETURN_STATUS(status)

	// Get the active sheet in current drawing
	ISheet *pSheet = NULL;
	status = pDrawingDoc->GetActiveSheet(&pSheet);
	CHECK_RETURN_STATUS(status)	

    status = pSheet->AddDimLine(CAST(IDimLine, pLinearDim));
	CHECK_RETURN_STATUS(status)
	
	// Add center line
	// To be done

	*lineardim = pLinearDim;
	
	END_METHOD("LinearDimension")
}
